<?php

namespace App\Enums;

enum NickNameEnum: int
{
    case Doctor = 1;
    case Engineer = 2;
    case Mr = 3;
    case Sheikh = 4;
    case Mrs = 5;
    case Ms = 6;
    case Professor = 7;
    case Shaikha = 8;
    case Lawyer = 9;

    public function getLabel(): ?string
    {
        return match ($this) {
            self::Doctor => __('Doctor'),
            self::Engineer => __('Engineer'),
            self::Mr => __('Mr'),
            self::Sheikh => __('Sheikh'),
            self::Mrs => __('Mrs'),
            self::Ms => __('Ms'),
            self::Professor => __('Professor'),
            self::Shaikha => __('Shaikha'),
            self::Lawyer => __('Lawyer'),
        };
    }
}
