<?php

namespace App\Http\Middleware;

use App\Models\Product;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureProductIsValid
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $product = Product::where([
            'product_id' => $request->header('product'),
            'key' => $request->header('product-key'),
        ])->first();

        if (!$product) {
            return response()->json([
                'success' => false,
                'message' => __('Invalid product'),
            ], Response::HTTP_BAD_REQUEST);
        }

        return $next($request);
    }
}
