<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Localized
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {   
        $lang = $request->header('language');

        if ($lang && in_array($lang, config('app.locales'))) {
            app()->setLocale($lang);
        } else {
            app()->setLocale('en');
        }

        return $next($request);
    }
}
