<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'product_id' => $this->product_id,
            'name' => app()->getLocale() == 'ar' ? $this->product_name : $this->product_name_en,
            'product_name' => $this->product_name,
            'product_name_en' => $this->product_name_en,
            'domain' => $this->domain,
            'dashboard_domain' => $this->dashboard_domain,
            'description' => $this->description,
            'logo' =>  env('SSO_DASHBOARD_BASE_URL') . '/storage/' .$this->logo,
            'token' => $this->pivot->token,
        ];
    }
}
