<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Support\Str;

class ProductUser extends Pivot
{
    protected $primaryKey = 'up_id';

    public $incrementing = true;

    protected $table = 'uproducts';

    public $timestamps = true;
    public const CREATED_AT = 'date';
    public const UPDATED_AT = 'ldate';

    public static function booted()
    {
        static::creating(function (self $productUser) {
            $productUser->token = Str::random();
        });
    }
}
