<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SLink extends Model
{
    public $table = 'slinks';

    public $primaryKey = 's_id';

    public $timestamps = false;

    protected $fillable = [
        's_id',
        'user_id',
        'type',
        'link',
        'date'
    ];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }
    public function provider()
    {
        return $this->belongsTo(SProvider::class, 'type', 'sp_id');
    }

}
