<?php

namespace Database\Factories;

use App\Enums\ActiveEnum;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'product_name' => fake()->name,
            'product_name_en' => fake()->name,
            'add_date' => fake()->dateTimeThisYear,
            'domain' => fake()->domainName,
            'invariable' => fake()->boolean,
            'description' => fake()->name,
            'active' => ActiveEnum::YES->value,
            'logo' => 'logos/01J0TS3WCXR4GTFKB591FPQEHH.png',
            'key' => 'secret_key',
        ];
    }
}
