<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Language;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class LanguagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::first();
        $language = Language::factory(1)->create([
            'title' => 'English',
            'code' => 'en',
            'user_id' => $user->user_id,
        ]);
        $user->lang = $language[0]->lan_id;
        $user->save();
    }
}
