<?php

namespace Database\Seeders;

use App\Enums\ImageTypeEnum;
use App\Models\User;
use App\Models\Image;
use App\Enums\UserTypesEnum;
use App\Enums\VerifiedEnum;
use Illuminate\Database\Seeder;
use Database\Factories\ImageFactory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $img = Image::factory(1)->create([
            'user_id' => 1,
            'image' => config('app.product_dashboard_domain') . '/avatar.png',
            'add_date' => fake()->dateTime,
            'type' => ImageTypeEnum::IMAGE_TYPE_PROFILE,
        ]);
        User::factory()->create([
            'email' => 'admin@admin.com',
            'username' => 'Admin',
            'language' => 'en',
            'user_type' => UserTypesEnum::ADMIN->value,
            'image' => $img[0]->img_id,
            'verified' => VerifiedEnum::YES->value,
            'city' => 1
        ]);
    }
}
