<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\PlatformController;
use Illuminate\Support\Facades\Route;

Route::prefix('auth')
    ->middleware('guest')
    ->group(function () {
        Route::post('/register', [AuthController::class, 'register'])
            ->name('auth.register');
        Route::post('/login', [AuthController::class, 'login'])
            ->name('auth.login');
        Route::post('/ext-login', [AuthController::class, 'extLogin'])
            ->name('auth.login');
        Route::post('/verify', [AuthController::class, 'verify'])
            ->name('auth.verify');
        Route::post('/resend-verify', [AuthController::class, 'resendVerify'])
            ->name('auth.resend-verify');
        Route::get('/social-platforms', [PlatformController::class, 'socialPlatforms'])
            ->name('auth.social-platforms');
        Route::get('/login/{provider}', [PlatformController::class, 'redirectToProvider'])
            ->name('auth.login.socialite');
        Route::get('/login/{provider}/callback', [PlatformController::class, 'handleProviderCallback'])
            ->name('auth.login.socialite.callback');
        Route::post('/forgot-password', [AuthController::class, 'forgotPassword'])
            ->name('auth.forgot-password')->middleware('throttle:6,1');
        Route::post('/reset-password', [AuthController::class, 'resetPassword'])
            ->name('auth.password-reset');
        Route::post('/check-ext-login', [AuthController::class, 'checkExtLogin'])
            ->name('auth.check-ext-login');
    });

Route::prefix('auth')
    // ->middleware('auth:api')
    ->group(function () {
        Route::post('/logout', [AuthController::class, 'logout'])
            ->name('auth.logout');
        Route::post('/refresh-token', [AuthController::class, 'refreshToken'])
            ->name('auth.refresh-token');
        Route::post('/change-password', [AuthController::class, 'changePassword'])
            ->name('auth.change-password');
        Route::post('/check-session', [AuthController::class, 'checkSession'])
            ->name('auth.check-session');
        Route::post('/logout-user/{userId}', [AuthController::class, 'logoutUserById'])
            ->name('auth.logout-user');
    });
