<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Data\DataController;

Route::prefix('/data')->group(function () {
    Route::get('/countries', [DataController::class, 'getCountries']);
    Route::get('/{country}/cities', [DataController::class, 'getCities']);
    Route::get('/country/{city}', [DataController::class, 'getCountry']);
    Route::get('/city/{city}', [DataController::class, 'getCity']);
    Route::get('/allcities', [DataController::class, 'getAllCities']);
});
