<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\Product;
use Illuminate\Foundation\Testing\RefreshDatabase;

class CountriesTest extends TestCase
{
    use RefreshDatabase;

    /**
     * Test getting countries.
     *
     * @return void
     */
    public function testGetCountries()
    {
        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;
        $response = $this->getJson('/api/data/countries', [
            'product' => $product_id,
            'product-key' => $key,
        ]);

        $response->assertStatus(200);
    }
}
