<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Product;
use App\Constants\UserConstants;
use Illuminate\Http\UploadedFile;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;

class UserUpdateTest extends TestCase
{
    use WithFaker;
    use RefreshDatabase;

    public function testUpdateUserDetails()
    {
        $user = User::factory()->create();

        $product = Product::factory()->create();
        $product_id = $product->product_id;
        $key = $product->key;
        
        $this->actingAs($user, 'api');

        // $imageFile = Image::factory()->create(['user_id' => $user->user_id, 'type' => UserConstants::IMAGE_TYPE_PROFILE]);
        // $coverFile = Image::factory()->create(['user_id' => $user->user_id, 'type' => UserConstants::IMAGE_TYPE_COVER]);

        $imageFile = UploadedFile::fake()->image('main_image.jpg');
        $coverFile = UploadedFile::fake()->image('cover_image.jpg');


        $this->assertDatabaseMissing('users', [
            'username' => 'newname',
        ]);

        $response = $this->postJson('/api/users/' . $user->user_id, [
            'username' => 'newname',
            'email' => 'new.name@example.com',
            'image' => $imageFile,
            'cover' => $coverFile,
        ], [
            'product' => $product_id,
            'product-key' => $key,
        ]);

        $response->assertStatus(200)
            ->assertJson(['message' => __('User details updated successfully')]);

        $this->assertDatabaseHas('users', [
            'user_id' => $user->user_id,
            'username' => 'newname',
            'email' => 'new.name@example.com',
        ]);

        $this->assertDatabaseHas('images', [
            'user_id' => $user->user_id,
            'type' => UserConstants::IMAGE_TYPE_PROFILE,
        ]);

        $this->assertDatabaseHas('images', [
            'user_id' => $user->user_id,
            'type' => UserConstants::IMAGE_TYPE_COVER,
        ]);
    }
}
